#!/opt/sitespect/bin/perl
# update shebang above if needed
# provided by SiteSpect as an example. 2021-10-06 dg
# see https://developers.sitespect.com/ for API reference

use LWP::UserAgent;
use Encode;
use JSON;
use File::Path qw(make_path);
use Data::Dumper;


# url of control panel
$url = "https://admin1.sitespect.com";
# API key from control panel profile of user
$key = "your_api_key";

# the configuration site ID (shown in the URL parameter from the control panel)
$siteid = 645;
# a prefix string that is part of the naming convention of the saved files from this script
# this is intended to help identify the files and is usually a date YYYY-MM-DD
$profile =  "2021-10-01";


# authenticate
$ua = LWP::UserAgent->new;
$ua->ssl_opts(verify_hostname => 0);
$ua->timeout(3600);
$t = "";

print "Authenticating...\n";
$req = HTTP::Request->new(POST => "$url/api/token");
$post_data = '{"apikey":"'.$key.'"}';
$req->content($post_data);
$resp = $ua->request($req);
if ($resp->is_success) {
    my $json = $resp->content;
    my $decoded = decode_json($json);
    $t = $decoded->{'token'};
    print "Token Obtained; Authentication Complete\n\n";
}
else {
    print "Authenticating: HTTP error code: ", $resp->code, "\n";
    print "Authenticating: HTTP error message: ", $resp->message, "\n";
    exit;
}

# dateFilename() will create a struction for the output files output/prefix_name/[each file]
$outfile = dateFilename();

# Campaigns() will call ExportPM() for each.
# This is a synchronous script as is a recommended approach for batch exporting.
Campaigns($t, $siteid);


sub Campaigns{
	my ($token, $siteid) = @_;
	my $req = HTTP::Request->new(GET => "$url/api/site/$siteid/campaigns/active-running");
	$req->header('X-API-TOKEN' => $token);
	my $resp = $ua->request($req);
	if ($resp->is_success) {
		$filename = $outfile;
    my $json = $resp->content;
    my $decoded = decode_json($json);
    my $jsonstr;
    my $cnt = 1;
		foreach my $campaign ( @{$decoded->{'_embedded'}->{'campaigns'}} ){
			print $cnt.": ".$siteid."\t".$campaign->{Name}." (".$campaign->{ID}.")\t".$campaign->{Status}."\t".$campaign->{Assignments}."\t".$campaign->{Visits}."\n";
			exportPM($t, $siteid, $campaign->{ID});
			$cnt++;
		}
    print "\nCampaign Count: $cnt\n";
	}
	else {
    print "HTTP POST error code: ", $resp->code, "\n";
    print "HTTP POST error message: ", $resp->message, "\n";
	}
}


sub exportPM{
	my ($token, $site, $campaign) = @_;
  print "Data Export for $campaign\n";
  # note: if you want the Performance Matrix exported in JSON format, add the parameter &accept=json to the following call
	my $req = HTTP::Request->new(GET => "$url/api/site/$site/campaign/$campaign/campaigndata/performancematrix/visit/maineffects?precision=6");
	$req->header('X-API-TOKEN' => $token);
	 
	my $resp = $ua->request($req);
	if ($resp->is_success) {
		$data = $resp->content;
		open OUTFILEEXPORT, ">$outfile.export_$campaign.csv" or die "Couldn't open file: $!";
		print OUTFILEEXPORT "$data";
		close (OUTFILEEXPORT);
	}
	else{
		print "$currtime\n";
	    print "exportPM: HTTP error code: ", $resp->code, "\n";
	    print "exportPM: HTTP error message: ", $resp->message, "\n";
	    print "pausing for 20 seconds before moving to the next one\n";
	    sleep(20);
	}
}

sub dateFilename{
  my $topdir = "output/";
  my $str = $profile."_".$siteid."_output";
  my $dir = $str."/";
  my $pathtodir = $topdir.$dir;
  if (! -e $pathtodir) {
    make_path($pathtodir);
  }
  return $pathtodir.$str;
}
