# python script that exports daily active campaign data from SiteSpect
# code that sends data to S3 needs to be filled out and tested in pushDataAWS()
# Provided as an example by SiteSpect. dg, 2019.02.01
# Be sure to insert the SiteSpect API Key in the var apikey. This can be found in the control panel profile

import requests
import json
import sys
import datetime
from datetime import timedelta
import boto
import boto.s3
from boto.s3.key import Key


# Add key from SiteSpect control panel profile
apikey = ""
siteID = TBC

def exportDataSet(campID):
  now = datetime.datetime.now() - timedelta(days=1)
  filename = str(now)[:10] + "_campaign_" + str(siteID) + "_" + str(campID) + ".csv"
  starttime = str(now)[:10]+"T00:00:00"
  endtime = str(now)[:10]+"T23:59:59"
  campurl = "https://admin1.sitespect.com/api/site/" + str(siteID) + "/campaign/" + str(campID) + "/campaigndata/dataexport/user?starttime=" + str(starttime) + "&endtime=" + str(endtime)
  resp = requests.get(campurl, headers=header)
  print("Campaign export " + filename + ": " + str(resp.status_code), str(resp.reason))
  file = open(filename,"w") 
  file.write(resp.text) 
  file.close()
  # pushDataAWS(filename)


def pushDataAWS(filename):
  # fill in values for keys and bucket name, and uncomment call above
  AWS_ACCESS_KEY_ID = ''
  AWS_SECRET_ACCESS_KEY = ''

  bucket_name = AWS_ACCESS_KEY_ID.lower() + ''
  conn = boto.connect_s3(AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY)

  bucket = conn.create_bucket(bucket_name,
      location=boto.s3.connection.Location.DEFAULT)

  print('Uploading %s to Amazon S3 bucket %s' % (filename, bucket_name))

  def percent_cb(complete, total):
      sys.stdout.write('.')
      sys.stdout.flush()


  k = Key(bucket)
  k.key = campaignresp.text
  k.set_contents_from_filename(filename, cb=percent_cb, num_cb=10)


#POST request to provide authentication and token
data = {"apikey":apikey}
resp = requests.post("https://admin1.sitespect.com/api/token",data=json.dumps(data))
token = json.loads(resp.text)["token"]
header = {"X-API-TOKEN": str(token)}
print ("Token Obtained; Authentication Complete")

# Get active campaigns list of IDs
campaignsURL = "https://admin1.sitespect.com/api/site/" + str(siteID) + "/campaigns/active-running"
campaignsresp = requests.get(campaignsURL, headers=header)
campaigns = json.loads(campaignsresp.text)

for campaigns in (campaigns['_embedded']['campaigns']):
  # Export Campaign Data and creates file on local system
  exportDataSet(campaigns['ID'])